/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.File;
import java.io.Serializable;
import java.rmi.server.UID;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.GroupConfig;
import oracle.ias.cache.group.GroupException;
import oracle.ias.cache.group.GroupManager;
import oracle.ias.cache.group.Monitor;
import oracle.ias.cache.group.SSLManager;
import oracle.ias.cache.group.Transport;

public class GroupCommunication {
    static String EXP_GRP_INTERNAL;
    static String EXP_GRP_INVALIDADDR;
    static String EXP_GRP_BASE;
    static String EXP_GRP_INVALIDCHANNEL;
    static String EXP_GRP_VIEWINFOEMPTY;
    static String EXP_GRP_VIEWNULL;
    static String EXP_GRP_NOLOCALHOST;
    static String EXP_GRP_PORTINUSE;
    static String EXP_GRP_SOCKETINITFAIL;
    static String EXP_GRP_INVALIDPAR;
    static String EXP_GRP_NULLPOINTER;
    static String EXP_GRP_REPLYISNULL;
    static String EXP_GRP_NOCONNECTION;
    static String EXP_GRP_NOGROUPINFO;
    static String EXP_GRP_NOTINITIALIZED;
    static String EXP_GRP_WRONG_MODE;
    static String EXP_GRP_INVALID_STREAM;
    static String EXP_GRP_INVALID_HTTP;
    static String EXP_GRP_CON_TERMINATED;
    static String EXP_GRP_SSL_PROVIDER_INSTANTIATION;
    static String EXP_GRP_SSL_PROVIDER_CLASSNOTFOUND;
    static String EXP_GRP_SSL_PROVIDER_CLASSCAST;
    static String EXP_GRP_SSL_CONFIG;
    static String EXP_GRP_SSL_SSOCKET;
    static String EXP_GRP_SSL_SOCKET;
    public static final int OFF = -1;
    public static final int FATAL = 0;
    public static final int ERROR = 3;
    public static final int DEFAULT = 4;
    public static final int WARNING = 6;
    public static final int TRACE = 7;
    public static final int INFO = 10;
    public static final int DEBUG = 15;
    public static final String LOGGING = "oracle.ias.cache.group.logging";
    public static final String LOG_LEVEL = "oracle.ias.cache.group.loglevel";
    static GroupConfig s_config;
    static boolean ready;
    static boolean logging;
    static int logLevel;
    public static int DEFAULT_GROUP_DAEMON_PORT;
    static String logId;

    public static void init(boolean bl) throws GroupException {
        Vector<Address> vector = new Vector<Address>();
        vector.addElement(new Address(12345));
        GroupCommunication.init(bl, vector, null);
    }

    public static void init(boolean bl, Serializable serializable) throws GroupException {
        Vector<Address> vector = new Vector<Address>();
        vector.addElement(new Address(12345));
        GroupCommunication.init(bl, vector, serializable);
    }

    public static void init(boolean bl, Vector vector) throws GroupException {
        GroupCommunication.init(bl, vector, null);
    }

    public static void init(boolean bl, Vector vector, Serializable serializable) throws GroupException {
        GroupConfig groupConfig = new GroupConfig();
        groupConfig.setListenerList(vector);
        groupConfig.setTag(serializable);
        GroupCommunication.init(bl, groupConfig);
    }

    public static void init(boolean bl, GroupConfig groupConfig) throws GroupException {
        if (ready) {
            return;
        }
        s_config = groupConfig;
        try {
            ResourceBundle resourceBundle = CacheInternal.initExceptionLocale();
            if (resourceBundle == null) {
                GroupCommunication.log("Can't read exception locale.");
            } else {
                EXP_GRP_INTERNAL = resourceBundle.getString("EXP_GRP_INTERNAL");
                EXP_GRP_INVALIDADDR = resourceBundle.getString("EXP_GRP_INVALIDADDR");
                EXP_GRP_BASE = resourceBundle.getString("EXP_GRP_BASE");
                EXP_GRP_INVALIDCHANNEL = resourceBundle.getString("EXP_GRP_INVALIDCHANNEL");
                EXP_GRP_VIEWINFOEMPTY = resourceBundle.getString("EXP_GRP_VIEWINFOEMPTY");
                EXP_GRP_VIEWNULL = resourceBundle.getString("EXP_GRP_VIEWNULL");
                EXP_GRP_NOLOCALHOST = resourceBundle.getString("EXP_GRP_NOLOCALHOST");
                EXP_GRP_PORTINUSE = resourceBundle.getString("EXP_GRP_PORTINUSE");
                EXP_GRP_SOCKETINITFAIL = resourceBundle.getString("EXP_GRP_SOCKETINITFAIL");
                EXP_GRP_INVALIDPAR = resourceBundle.getString("EXP_GRP_INVALIDPAR");
                EXP_GRP_NULLPOINTER = resourceBundle.getString("EXP_GRP_NULLPOINTER");
                EXP_GRP_REPLYISNULL = resourceBundle.getString("EXP_GRP_REPLYISNULL");
                EXP_GRP_NOCONNECTION = resourceBundle.getString("EXP_GRP_NOCONNECTION");
                EXP_GRP_NOGROUPINFO = resourceBundle.getString("EXP_GRP_NOGROUPINFO");
                EXP_GRP_NOTINITIALIZED = resourceBundle.getString("EXP_GRP_NOTINITIALIZED");
                EXP_GRP_WRONG_MODE = resourceBundle.getString("EXP_GRP_WRONG_MODE");
                EXP_GRP_INVALID_STREAM = resourceBundle.getString("EXP_GRP_INVALID_STREAM");
                EXP_GRP_INVALID_HTTP = resourceBundle.getString("EXP_GRP_INVALID_HTTP");
                EXP_GRP_CON_TERMINATED = resourceBundle.getString("EXP_GRP_CON_TERMINATED");
                EXP_GRP_SSL_PROVIDER_INSTANTIATION = resourceBundle.getString("EXP_GRP_SSL_PROVIDER_INSTANTIATION");
                EXP_GRP_SSL_PROVIDER_CLASSNOTFOUND = resourceBundle.getString("EXP_GRP_SSL_PROVIDER_CLASSNOTFOUND");
                EXP_GRP_SSL_PROVIDER_CLASSCAST = resourceBundle.getString("EXP_GRP_SSL_PROVIDER_CLASSCAST");
                EXP_GRP_SSL_CONFIG = resourceBundle.getString("EXP_GRP_SSL_CONFIG");
                EXP_GRP_SSL_SSOCKET = resourceBundle.getString("EXP_GRP_SSL_SSOCKET");
                EXP_GRP_SSL_SOCKET = resourceBundle.getString("EXP_GRP_SSL_SOCKET");
            }
            if (s_config.getSSLEnabled()) {
                SSLManager.init(s_config.getSSLConfig());
            }
            Transport.init(s_config.getListenerList(), bl, s_config.getTag(), s_config.getLocalAddress());
            Monitor monitor = Monitor.getInstance();
            monitor.start();
            ready = true;
            logId = "[" + Transport.getLocalAddress().getPosition() + "] ";
            String string = System.getProperty(LOGGING);
            logging = CacheInternal.logger != null && string == null;
            String string2 = System.getProperty(LOG_LEVEL);
            if (string2 != null) {
                if (string2.equalsIgnoreCase("OFF")) {
                    logLevel = -1;
                } else if (string2.equalsIgnoreCase("FATAL")) {
                    logLevel = 0;
                } else if (string2.equalsIgnoreCase("ERROR")) {
                    logLevel = 3;
                } else if (string2.equalsIgnoreCase("DEFAULT")) {
                    logLevel = 4;
                } else if (string2.equalsIgnoreCase("WARNING")) {
                    logLevel = 6;
                } else if (string2.equalsIgnoreCase("TRACE")) {
                    logLevel = 7;
                } else if (string2.equalsIgnoreCase("INFO")) {
                    logLevel = 10;
                } else if (string2.equalsIgnoreCase("DEBUG")) {
                    logLevel = 15;
                }
            }
        }
        catch (GroupException groupException) {
            throw groupException;
        }
        catch (Exception exception) {
            throw new GroupException(EXP_GRP_BASE + exception.toString(), exception);
        }
        if (GroupCommunication.shouldLog(10)) {
            GroupCommunication.log("GroupCommunication is initialized.");
        }
    }

    public static void term() {
        if (!ready) {
            return;
        }
        ready = false;
        Monitor.getInstance().stopit();
        Transport.term();
        GroupManager.term();
        logId = null;
        if (GroupCommunication.shouldLog(10)) {
            GroupCommunication.log("GroupCommunication is terminated.");
        }
    }

    public static boolean isReady() {
        return ready;
    }

    public static synchronized void dump() {
        GroupCommunication.log("<<< Begin Group Communication Internal Data Structure Dump >>>");
        try {
            Transport.dump();
            GroupManager.dump();
        }
        catch (Exception exception) {
            GroupCommunication.log("dump exception", exception);
        }
        catch (Error error) {
            GroupCommunication.log("dump error", error);
        }
        GroupCommunication.log("<<< End Group Communication Internal Data Structure Dump >>>");
    }

    public static void log(String string) {
        if (logging) {
            CacheInternal.log("[Grp] " + string);
        } else {
            System.err.println(string);
        }
    }

    public static void log(String string, Throwable throwable) {
        if (logging) {
            CacheInternal.log("[Grp] " + string, throwable);
        } else {
            System.err.println(string);
            throwable.printStackTrace();
        }
    }

    public static boolean shouldLog(int n) {
        boolean bl = false;
        if (logging) {
            bl = CacheInternal.shouldLog(n);
        } else if (n <= logLevel) {
            bl = true;
        }
        return bl;
    }

    public static String getVersion() {
        return s_config.getVersion();
    }

    public static String getTempFilePath() {
        String string = GroupCommunication.getWorkingDir() + File.separator + GroupCommunication.getUniqFileName();
        return string;
    }

    public static String getUniqFileName() {
        UID uID = new UID();
        return uID.toString().replace(':', '_');
    }

    public static int getMode() {
        return s_config.getMode();
    }

    public static String getWorkingDir() {
        return s_config.getWorkingDir();
    }

    public static GroupConfig getGroupConfig() {
        return s_config;
    }

    static {
        ready = false;
        logging = true;
        logLevel = 4;
        DEFAULT_GROUP_DAEMON_PORT = 8866;
        logId = null;
    }
}

